Just as you can interpolate (insert) arguments into Bonnie commands, you can do the same with environment variables. Bonnie also supports loading environment variable files like `.env` directly.

```toml
version = "0.3.2"
env_files = [ ".env" ]

[scripts]
test.cmd = "echo \"%GREETING %name!\""
test.args = [ "name" ]
test.env_vars = [ "GREETING" ]
```

```
# .env
GREETING=Hello
```

```
bonnie test Bonnie	# Hello Bonnie!
```

The above example combines arguments and environment variables together so you can see the similarities in syntax. if you need a refresher on this syntax, see the page on [Arguments](./Arguments).

Note that environment variable references must have the same name as the actual environment variables themselves. You can't reference `$GREETING` as `%greeting`.

Bonnie can access any environment variables given to its process, as well as any in files like `.env` specified in the top-level `env_files` array.

Also, environment variables accessed by Rust must be valid Unicode, and if you want to have spaces in environment variable files, put them in quotation marks.
